package org.msh.tb.bd.tbforms.query.tb11;

import org.msh.tb.bd.Quarter;
import org.msh.tb.bd.tbforms.query.TbFormQuery;
import org.msh.tb.entities.AdministrativeUnit;
import org.msh.tb.entities.Tbunit;
import org.msh.tb.entities.Workspace;

import javax.persistence.EntityManager;
import javax.persistence.Query;
import java.util.ArrayList;
import java.util.List;

/**
 * Created by Mauricio on 17/03/2017.
 * Generate query result to mount TB11 Block 3 (HIV Activities Table)
 */
public class TBForm11Block3HIVActivitiesQuery implements TbFormQuery {

    @Override
    public List<Object[]> queryDB(Tbunit tbunit, AdministrativeUnit adminUnit, Workspace workspace, Quarter selectedQuarter, EntityManager em) {
        Query queryART;
        Query queryCPT;
        Query queryTotal;

        String queryStrTotal = " select 'TOTAL', p.gender, count(distinct p.id)"
                + " from TbCase c join c.patient p"
                + " where c.registrationDate between :iniDate and :endDate %restriction% "
                + " and c.classification = 0 and c.diagnosisType = 1 "
                + " and c.patientType in (0,44,48)"
                + " and c.state is not null and p.gender is not null and c.infectionSite is not null and c.caseDefinition is not null"
                + " and exists(from ExamHIV e where e.tbcase.id = c.id)"
                + " group by p.gender ";

        String queryStrART = " select 'ART', p.gender, count(distinct p.id)"
                + " from TbCase c join c.patient p"
                + " where c.registrationDate between :iniDate and :endDate %restriction% "
                + " and c.classification = 0 and c.diagnosisType = 1 "
                + " and c.patientType in (0,44,48)"
                + " and c.state is not null and p.gender is not null and c.infectionSite is not null and c.caseDefinition is not null"
                + " and exists(from ExamHIV e where e.tbcase.id = c.id and e.startedARTdate is not null)"
                + " group by p.gender ";

        String queryStrCPT = " select 'CPT', p.gender, count(distinct p.id)"
                + " from TbCase c join c.patient p"
                + " where c.registrationDate between :iniDate and :endDate %restriction% "
                + " and c.classification = 0 and c.diagnosisType = 1 "
                + " and c.patientType in (0,44,48)"
                + " and c.state is not null and p.gender is not null and c.infectionSite is not null and c.caseDefinition is not null"
                + " and exists(from ExamHIV e where e.tbcase.id = c.id and e.startedCPTdate is not null)"
                + " group by p.gender ";

        if (tbunit != null) {
            // add tbunit restriction on ART
            queryStrART = queryStrART.replace("%restriction%", "and c.notificationUnit.id = :unitId");
            queryART = em.createQuery(queryStrART);
            queryART.setParameter("unitId", tbunit.getId());

            // add tbunit restriction on CPT
            queryStrCPT = queryStrCPT.replace("%restriction%", "and c.notificationUnit.id = :unitId");
            queryCPT = em.createQuery(queryStrCPT);
            queryCPT.setParameter("unitId", tbunit.getId());

            // add tbunit restriction on total
            queryStrTotal = queryStrTotal.replace("%restriction%", "and c.notificationUnit.id = :unitId");
            queryTotal = em.createQuery(queryStrTotal);
            queryTotal.setParameter("unitId", tbunit.getId());
        } else if (adminUnit != null) {
            // add adminunit restriction ART
            queryStrART = queryStrART.replace("%restriction%", "and c.notificationUnit.adminUnit.code like :code");
            queryART = em.createQuery(queryStrART);
            queryART.setParameter("code", adminUnit.getCode() + "%");

            // add adminunit restriction CPT
            queryStrCPT = queryStrCPT.replace("%restriction%", "and c.notificationUnit.adminUnit.code like :code");
            queryCPT = em.createQuery(queryStrCPT);
            queryCPT.setParameter("code", adminUnit.getCode() + "%");

            // add tbunit restriction on total
            queryStrTotal = queryStrTotal.replace("%restriction%", "and c.notificationUnit.adminUnit.code like :code");
            queryTotal = em.createQuery(queryStrTotal);
            queryTotal.setParameter("code", adminUnit.getCode() + "%");
        } else if (workspace != null) {
            // add workspace restriction ART
            queryStrART = queryStrART.replace("%restriction%", "and c.patient.workspace.id = :wsId");
            queryART = em.createQuery(queryStrART);
            queryART.setParameter("wsId", workspace.getId());

            // add workspace restriction CPT
            queryStrCPT = queryStrCPT.replace("%restriction%", "and c.patient.workspace.id = :wsId");
            queryCPT = em.createQuery(queryStrCPT);
            queryCPT.setParameter("wsId", workspace.getId());

            // add tbunit restriction on total
            queryStrTotal = queryStrTotal.replace("%restriction%", "and c.patient.workspace.id = :wsId");
            queryTotal = em.createQuery(queryStrTotal);
            queryTotal.setParameter("wsId", workspace.getId());
        } else {
            throw new RuntimeException("Tbunit, adminunit or workspace must be set.");
        }

        queryART.setParameter("iniDate", selectedQuarter.getIniDate());
        queryART.setParameter("endDate", selectedQuarter.getEndDate());

        queryCPT.setParameter("iniDate", selectedQuarter.getIniDate());
        queryCPT.setParameter("endDate", selectedQuarter.getEndDate());

        queryTotal.setParameter("iniDate", selectedQuarter.getIniDate());
        queryTotal.setParameter("endDate", selectedQuarter.getEndDate());

        List<Object[]> result = new ArrayList<Object[]>();
        result.addAll(queryART.getResultList());
        result.addAll(queryCPT.getResultList());
        result.addAll(queryTotal.getResultList());

        return result;
    }
}
